import AboutSection from "@/(pages)/homePage/AboutSection";
import FeaturesSectionWithImage from "@/(pages)/homePage/CardSection";
import FeaturesSection from "@/(pages)/homePage/FeaturesSection";
import HeroSection from "@/(pages)/homePage/HeroSection";
import ImagesSection from "@/(pages)/homePage/ImageSection";
import ContactSection from "@/(pages)/homePage/Map";
import Shipping from "@/(pages)/homePage/ShippingSection";
import WhySection from "@/(pages)/homePage/WhyFastSection";
import { metaObject } from "@/config/site.config";
import { getTranslations } from "next-intl/server";
export async function generateMetadata() {
  const t = await getTranslations("METADATA");
  return metaObject(
    t("HOME_TITLE") || "Fast Express - Delivery & Shipping",
    t("HOME_DESC") ||
      "Fast Express provides fast and secure delivery solutions by road, air, and sea with competitive prices and real-time tracking.",
    undefined,
    undefined
  );
}
export default function Home() {
  return (
    <>
      <HeroSection />
      <AboutSection />
      <FeaturesSectionWithImage />
      <WhySection />
      <FeaturesSection />
      <ImagesSection />
      <Shipping />
      <ContactSection />
    </>
  );
}
